#ifndef __C_SIMENGINE_H
#define __C_SIMENGINE_H

#define WIN32_LEAN_AND_MEAN

#include "cSimNetLayerParam.h"

class cSimMsgQueue;
class cSimNode;
class cSimEndpoint;
class cMsgBuffer;
class cSimMsgHeap;

/*
 * cSimEngine.h
 *
 * Simulated network layer engine.
 */
class cSimEngine
{

  public:

	cSimEngine(cSimNetLayerParam* param);
	~cSimEngine();
	
	bool	GetFreshEndpoint(HANDLE eventHandle, cSimEndpoint** outEp);
	bool    Send(cSimEndpoint* sender, cSimEndpoint* dest, cMsgBuffer* buffer, unsigned int messageType);
	bool	GetMessage(cSimEndpoint* ep, cSimEndpoint** outEp, cMsgBuffer** outBuf, unsigned int* type);
	bool	Schedule();


  private:

	cSimMsgHeap*		mNetQueue;
	cSimMsgQueue*		mDeliverQueue;
	cSimNetLayerParam	mParam;
	cSimNode**			mNodes;
	unsigned int		mSubnetCount;
	unsigned int		mAddressCount;

};

#endif
